<?php
// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
define('CVS_REVISION', '$RCSfile$ - $Revision: 2 $');

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('cphome', 'giftcp');
$specialtemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/functions_faq.php');

// ######################## CHECK ADMIN PERMISSIONS #######################
if (!can_administer('canadmingifts'))
{
	print_cp_no_permission();
}

// ############################# LOG ACTION ###############################
log_admin_action();

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

print_cp_header($vbphrase['giftcp_gift_manager']);

// #############################################################################

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'list';
}

// #############################################################################

if ($_REQUEST['do'] == 'list')
{
	// get the number of gift types
	$types = $db->query_read('
		SELECT
			gift_type.gifttypeid, gift_type.title, gift_type.description,
			gift_type.image, gift_type.active, gift_type.categoryid,gift_type.credits,
			gift_categories.title AS categorytitle
		FROM ' . TABLE_PREFIX . 'gift_type AS gift_type
		LEFT JOIN ' . TABLE_PREFIX . 'gift_categories AS gift_categories ON gift_type.categoryid = gift_categories.categoryid
		ORDER BY categoryid DESC
	');
	
	print_table_start();
	
	if ($db->num_rows($types) == 0)
	{
		print_table_header($vbphrase['giftcp_manage'], 1);
		print_cells_row(array($vbphrase['giftcp_nogifts']));
	
	}
	else
	{
		print_table_header($vbphrase['giftcp_manage'], 7);
		print_cells_row(
			array(
				$vbphrase['giftcp_name'],
				$vbphrase['giftcp_description'],
				$vbphrase['giftcp_image'],
				$vbphrase['giftcp_credits'],
				$vbphrase['giftcp_active'],
				$vbphrase['giftcp_category'],
				$vbphrase['giftcp_actions']
			),
			1,
			'',
			-1
		);
		
		while ($type = $db->fetch_array($types))
		{
			// construct actions list
			$actions = construct_link_code($vbphrase['edit'], 'gifts.php?' . $vbulletin->session->vars['sessionurl'] . 'do=edit&amp;id=' . $type['gifttypeid'], 0, 1) . "<br />" . construct_link_code($vbphrase['delete'], 'gifts.php?' . $vbulletin->session->vars['sessionurl'] . 'do=delete&amp;id=' . $type['gifttypeid'], 0, 1);
			
			// Im a total security nut.
			$type['description'] = htmlspecialchars_uni($type['description']);
			$type['title'] = htmlspecialchars_uni($type['title']);
			$type['image'] = htmlspecialchars_uni($type['image']);
			$type['categorytitle'] = htmlspecialchars_uni($type['categorytitle']);
			
			// print all the cells
			print_cells_row(
				array(
					$type['title'],
					$type['description'],
					($type['image'] ? '<img src="' . $type['image'] . '" border="0" alt="' . $type['title'] . ' Image" />' : ''),
					$type['credits'],
					($type['active'] == 1 ? 'Yes' : 'No'),
					$type['categorytitle'],
					$actions
				)
			);
				
		}
	}
	print_table_footer();
	print_cp_footer();
}

// #############################################################################

if ($_REQUEST['do'] == 'add')
{
	print_form_header('gifts', 'insert');
	print_table_header($vbphrase['giftcp_addgift']);
	
	print_input_row($vbphrase['giftcp_name'], 'title', '', 0);
	print_textarea_row($vbphrase['giftcp_description'], 'description', '', 0);
	
	// get categories
	$categories = $db->query_read('
		SELECT
			gift_categories.categoryid, gift_categories.title
		FROM ' . TABLE_PREFIX . 'gift_categories AS gift_categories
	');
	
	$catarr = array();
	while ($category = $db->fetch_array($categories))
	{
		$catarr[$category[categoryid]] = $category['title'];
	}
	
	print_select_row($vbphrase['giftcp_categories'], "category", $catarr);
	print_input_row($vbphrase['giftcp_image'] . " URL", 'image','',0);
	print_input_row($vbphrase['giftcp_credits'], 'credits','0',0);
	print_yes_no_row($vbphrase['giftcp_active'],'active',1);
	print_submit_row();
	
	print_table_footer();
	print_cp_footer();
}

// #############################################################################

if ($_REQUEST['do'] == 'insert')
{
	$vars = array(
		'title' 			=> TYPE_STR,
		'description'		=> TYPE_STR,
		'image'		=> TYPE_STR,
		'credits'	=> TYPE_NUM,
		'active'		=> TYPE_BOOL,
		'category' => TYPE_UINT
	);
	
	$vbulletin->input->clean_array_gpc('r', $vars);
	
	if ($vbulletin->GPC['title'] == '')
	{
		print_stop_message('invalid_title_specified');
	}
	
	$db->query_write('
		INSERT INTO ' . TABLE_PREFIX . 'gift_type
			(title, description, image, active, categoryid,credits)
		VALUES
			("' . htmlspecialchars_uni($db->escape_string($vbulletin->GPC['title'])) . '",
			"' . htmlspecialchars_uni($db->escape_string($vbulletin->GPC['description'])) . '",
			"' . htmlspecialchars_uni($db->escape_string($vbulletin->GPC['image'])) . '",
			' . $vbulletin->GPC['active'] . ',
			' . $vbulletin->GPC['category'] . ',
			' . $vbulletin->GPC['credits'] . ')
		');
	
	define('CP_REDIRECT', 'gifts.php?do=list');
	print_stop_message('giftcp_added');
	
}

// #############################################################################

if ($_REQUEST['do'] == 'edit')
{
		$vbulletin->input->clean_array_gpc('r', array(
			'id' => TYPE_UINT
		));
		
		$gift = $db->query_first('
			SELECT * FROM ' . TABLE_PREFIX . 'gift_type AS gift_type
			WHERE gifttypeid = ' . $vbulletin->GPC['id']
		);
		if (!$gift)
		{
			print_stop_message('no_matches_found');
		}
		
		print_form_header('gifts', 'update');
		construct_hidden_code('id', $gift['gifttypeid']);
		
		print_table_header($vbphrase['giftcp_editgift']);
		
		print_input_row($vbphrase['giftcp_name'], 'title', $gift['title'], 0);
		print_textarea_row($vbphrase['giftcp_description'], 'description', $gift['description'], 0);
		
		$categories = $db->query_read('
			SELECT
				gift_categories.categoryid, gift_categories.title
			FROM ' . TABLE_PREFIX . 'gift_categories AS gift_categories
		');
		
		$catarr = array();
		while ($category = $db->fetch_array($categories))
		{
			$catarr[$category[categoryid]] = $category['title'];
		}
	
		print_select_row($vbphrase['giftcp_categories'], "category", $catarr, $gift['categoryid']);
		print_input_row($vbphrase['giftcp_image'] . " URL", 'image', $gift['image'], 0);
		print_input_row($vbphrase['giftcp_credits'], 'credits', $gift['credits'], 0);
		print_yes_no_row($vbphrase['giftcp_active'],'active',($gift['active']==1 ? 1 : 0));
		print_submit_row();
		
		print_table_footer();
		print_cp_footer();
}

// #############################################################################

if ($_REQUEST['do'] == 'update')
{
	$vars = array(
		'title' 			=> TYPE_STR,
		'description'		=> TYPE_STR,
		'image'		=> TYPE_STR,
		'credits'	=> TYPE_NUM,
		'active'		=> TYPE_BOOL,
		'id' => TYPE_UINT,
		'category' => TYPE_UINT
	);
	
	$vbulletin->input->clean_array_gpc('r', $vars);
	
	if ($vbulletin->GPC['title'] == '')
	{
		print_stop_message('invalid_title_specified');
	}
	
	$db->query_write('
		UPDATE ' . TABLE_PREFIX . 'gift_type SET
			title = "' . htmlspecialchars_uni($db->escape_string($vbulletin->GPC['title'])) . '",
			description = "' . htmlspecialchars_uni($db->escape_string($vbulletin->GPC['description'])) . '",
			image = "' . htmlspecialchars_uni($db->escape_string($vbulletin->GPC['image'])) . '",
			credits='.$vbulletin->GPC['credits'].',
			active = ' . $vbulletin->GPC['active'] . ',
			categoryid = ' . $vbulletin->GPC['category'] . '
		WHERE gifttypeid = ' . $vbulletin->GPC['id']
	);
	
	define('CP_REDIRECT', 'gifts.php?do=list');
	print_stop_message('giftcp_edited');
}

if ($_REQUEST['do'] == 'delete')
{
	$vbulletin->input->clean_gpc('r','id', TYPE_UINT);
	
	print_form_header('gifts', 'processdelete');
	construct_hidden_code('id', $vbulletin->GPC['id']);
	print_table_header('Are you sure you want to delete this?');
	print_yes_no_row('', 'delete', 0);
	print_submit_row();
}

if ($_REQUEST['do'] == 'processdelete')
{
	$vbulletin->input->clean_gpc('p','delete', TYPE_BOOL);
	$vbulletin->input->clean_gpc('p','id', TYPE_UINT);
	
	if ($vbulletin->GPC['delete'])
	{
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "gift_type WHERE gifttypeid = " . $vbulletin->GPC['id']);
		define('CP_REDIRECT', 'gifts.php?do=list');
		print_stop_message('gifts_deletedsuccessfully');
	}
	else
	{
		define('CP_REDIRECT', 'gifts.php?do=list');
	}
}

// #############################################################################
if ($_REQUEST['do'] == 'listcategories')
{
	$categories = $db->query_read('
		SELECT
			gift_categories.title, gift_categories.categoryid, gift_categories.description
		FROM ' . TABLE_PREFIX . 'gift_categories AS gift_categories
		ORDER BY categoryid DESC
	');
	
	print_table_start();
	
	if ($db->num_rows($categories) == 0)
	{
		print_table_header($vbphrase['giftcp_managecategories'], 1);
		print_cells_row(array($vbphrase['giftcp_nocategories']));
	
	}
	else
	{
		print_table_header($vbphrase['giftcp_managecategories'], 3);
		print_cells_row(
			array(
				$vbphrase['giftcp_name'],
				$vbphrase['giftcp_description'],
				$vbphrase['giftcp_actions']
			),
			1,
			'',
			-1
		);
		
		while ($category = $db->fetch_array($categories))
		{
			// construct actions list
			$actions = construct_link_code($vbphrase['edit'], 'gifts.php?' . $vbulletin->session->vars['sessionurl'] . 'do=editcategory&amp;id=' . $category['categoryid'], 0, 1) . "<br />" . construct_link_code($vbphrase['delete'], 'gifts.php?' . $vbulletin->session->vars['sessionurl'] . 'do=deletecategory&amp;id=' . $category['categoryid'], 0, 1);
			
			// Im a total security nut.
			$category['description'] = htmlspecialchars_uni($category['description']);
			$category['title'] = htmlspecialchars_uni($category['title']);
			
			// print all the cells
			print_cells_row(
				array(
					$category['title'],
					$category['description'],
					$actions
				)
			);
				
		}
	}
	print_table_footer();
	print_cp_footer();
}
// #############################################################################

if ($_REQUEST['do'] == 'editcategory')
{
		$vbulletin->input->clean_array_gpc('r', array(
			'id' => TYPE_UINT
		));
		
		$category = $db->query_first('
			SELECT * FROM ' . TABLE_PREFIX . 'gift_categories AS gift_categories
			WHERE categoryid = ' . $vbulletin->GPC['id']
		);
		if (!$category)
		{
			print_stop_message('no_matches_found');
		}
		
		print_form_header('gifts', 'updatecategory');
		construct_hidden_code('id', $category['categoryid']);
		
		print_table_header($vbphrase['giftcp_editcategory']);
		
		print_input_row($vbphrase['giftcp_name'], 'title', $category['title'], 0);
		print_textarea_row($vbphrase['giftcp_description'], 'description', $category['description'], 0);
		print_submit_row();
		
		print_table_footer();
		print_cp_footer();
}

// #############################################################################

if ($_REQUEST['do'] == 'addcategory')
{
		print_form_header('gifts', 'insertcategory');
		
		print_table_header($vbphrase['giftcp_addcategory']);
		
		print_input_row($vbphrase['giftcp_name'], 'title', '', 0);
		print_textarea_row($vbphrase['giftcp_description'], 'description', '', 0);
		print_submit_row();
		
		print_table_footer();
		print_cp_footer();
}

// #############################################################################

if ($_REQUEST['do'] == 'updatecategory')
{
	$vars = array(
		'title' 			=> TYPE_STR,
		'description'		=> TYPE_STR,
		'id' => TYPE_UINT
	);
	
	$vbulletin->input->clean_array_gpc('r', $vars);
	
	if ($vbulletin->GPC['title'] == '')
	{
		print_stop_message('invalid_title_specified');
	}
	
	$db->query_write('
		UPDATE ' . TABLE_PREFIX . 'gift_categories SET
			title = "' . htmlspecialchars_uni($db->escape_string($vbulletin->GPC['title'])) . '",
			description = "' . htmlspecialchars_uni($db->escape_string($vbulletin->GPC['description'])) . '"
		WHERE categoryid = ' . $vbulletin->GPC['id']
	);
	
	define('CP_REDIRECT', 'gifts.php?do=listcategories');
	print_stop_message('giftcp_category_edited');
}

// #############################################################################

if ($_REQUEST['do'] == 'insertcategory')
{
	$vars = array(
		'title' 			=> TYPE_STR,
		'description'		=> TYPE_STR
	);
	
	$vbulletin->input->clean_array_gpc('r', $vars);
	
	if ($vbulletin->GPC['title'] == '')
	{
		print_stop_message('invalid_title_specified');
	}
	
	$db->query_write('
		INSERT INTO ' . TABLE_PREFIX . 'gift_categories
			(title, description)
		VALUES
			("' . htmlspecialchars_uni($db->escape_string($vbulletin->GPC['title'])) . '",
			"' . htmlspecialchars_uni($db->escape_string($vbulletin->GPC['description'])) . '")
		');
	
	define('CP_REDIRECT', 'gifts.php?do=listcategories');
	print_stop_message('giftcp_category_added');
	
}

// #############################################################################

if ($_REQUEST['do'] == 'deletecategory')
{
	$vbulletin->input->clean_gpc('r','id', TYPE_UINT);
	
	print_form_header('gifts', 'processcatdelete');
	construct_hidden_code('id', $vbulletin->GPC['id']);
	print_table_header('Are you sure you want to delete this?');
	print_yes_no_row('', 'delete', 0);
	print_submit_row();
}

if ($_REQUEST['do'] == 'processcatdelete')
{
	$vbulletin->input->clean_gpc('p','delete', TYPE_BOOL);
	$vbulletin->input->clean_gpc('p','id', TYPE_UINT);
	
	if ($vbulletin->GPC['delete'])
	{
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "gift_categories WHERE categoryid = " . $vbulletin->GPC['id']);
		define('CP_REDIRECT', 'gifts.php?do=listcategories');
		print_stop_message('gifts_deletedsuccessfully');
	}
	else
	{
		define('CP_REDIRECT', 'gifts.php?do=list');
	}
}

		
?>